// Form with steps
var navListItems = $('div.setup-panel div a'),
    allWells = $('.setup-content'),
    allPrevBtn = $('.prevBtn');

$(document).ready(function () {

    allWells.hide();

    navListItems.click(function (e) {
        e.preventDefault();
        var $target = $($(this).attr('href')),
            $item = $(this);

        if (!$item.hasClass('disabled')) {
            navListItems.removeClass('btn-primary').addClass('btn-default');
            $item.addClass('btn-primary');
            allWells.hide();
            $target.show();
            $target.find('input:eq(0)').focus();
        }
    });

    allPrevBtn.click(function(){
        var curStep = $(this).closest(".setup-content"),
            curStepBtn = curStep.attr("id"),
            prevStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().prev().children("a");

        prevStepWizard.removeAttr('disabled').trigger('click');
    });

    $('div.setup-panel div a.btn-primary').trigger('click');
});

function nextStep(step){
    var nextStepWizard = $('div.setup-panel div a[href="#step-' + step + '"]').parent().next().children("a");
    nextStepWizard.removeAttr('disabled').trigger('click');
}


