<?php
/**
 * Created by PhpStorm.
 * User: Arthur Touzard
 * Date: 20/04/2018
 * Time: 09:03
 */

namespace AppBundle\Service;

use Swift_Mailer;
use Twig_Environment;

class Mailer
{
    private $mailer;
    private $twig;
    private $mailerFrom;

    /**
     * Mailer constructor.
     * @param $mailer
     */
    public function __construct(Swift_Mailer $mailer, Twig_Environment $twig, $mailerFrom)
    {
        $this->mailer = $mailer;
        $this->twig = $twig;
        $this->mailerFrom = $mailerFrom;
    }

    public function sendMail($title, $to, $template, $data)
    {
        $message = (new \Swift_Message($title))
            ->setFrom($this->mailerFrom)
            ->setTo($to)
            ->setBody(
                $this->twig->render(
                    $template,
                    $data
                ),
                'text/html'
            )
        ;

        return $this->mailer->send($message);
    }
}