<?php

namespace AppBundle\Form\User;

use AppBundle\Entity\Utilisateur;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserUpdate extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom', null, [
                'required' => true
            ])
            ->add('prenom', null, [
                'required' => true
            ])
            ->add('telephone', null, [
                'required' => true
            ])
            ->add('email', EmailType::class, [
                'required' => true
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Utilisateur::class
        ]);
    }

    public function getBlockPrefix()
    {
        return 'user_update';
    }
}
