<?php

namespace AppBundle\Form\User;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UpdateUserAdminType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom', null, [
                'attr' => [ 'class' => 'inscription' ]
            ])
            ->add('prenom', null, [
                'attr' => [ 'class' => 'inscription' ]
            ])
            ->add('email', null, [
                'attr' => [ 'class' => 'inscription' ]
            ])
            ->add('telephone', null, [
                'attr' => [ 'class' => 'inscription' ]
            ])
            ->add('dateFinBan', TextType::class, [
                'attr' => [ 'class' => 'datepicker inscription' ],
                'required' => false
            ])
            ->add('isAgent')
            ->add('isAdmin')
            ->add('isActif')
            ->add('hasValidated')
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'AppBundle\Entity\Utilisateur'
        ]);
    }

    public function getBlockPrefix()
    {
        return 'app_bundle_update_user_type';
    }
}
