<?php

namespace AppBundle\Form\User;

use AppBundle\Entity\Utilisateur;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PasswordUpdate extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('current', PasswordType::class, [
                'required' => true,
                'label' => 'CURRENT_PASSWORD'
            ])
            ->add('new', PasswordType::class, [
                'required' => true,
                'label' => 'NEW_PASSWORD'
            ])
            ->add('confirmation', PasswordType::class, [
                'required' => true,
                'label' => 'PASSWORD_CONFIRMATION'
            ])
        ;
    }

    public function getBlockPrefix()
    {
        return 'password_update';
    }
}
