<?php

namespace AppBundle\Form;

use AppBundle\Entity\Utilisateur;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UpdateAgent extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        /** @var Utilisateur $agent */
        $agent = $options['data']['agent'];
        $builder
            ->add('nom', null, [
                'data' => $agent->getNom(),
                'label' => 'NAME',
                'required' => true
            ])
            ->add('prenom', null, [
                'data' => $agent->getPrenom(),
                'label' => 'FIRSTNAME',
                'required' => true
            ])
            ->add("email", null, [
                'data' => $agent->getEmail(),
                'label' => 'EMAIL',
                'required' => true
                ])
            ->add('telephone', null, [
                'data' => $agent->getTelephone(),
                'label' => 'PHONE',
                'required' => false,
                ])
            ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }

    public function getBlockPrefix()
    {
        return 'app_bundle_update_agent';
    }
}
