<?php

namespace AppBundle\Form\Security;

use AppBundle\Entity\Utilisateur;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\EqualTo;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;

class UserPasswordReset extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('password', RepeatedType::class, [
                'type' => PasswordType::class,
                'invalid_message' => 'La confirmation ne correspond pas.',
                'required' => true,
                'constraints' => [
                    new NotBlank(),
                    new Length(['min'=>8]),
                    new Regex(['pattern'=>"/[a-zA-Z0-9]/", 'message' => 'Minimum 8 caractères, une majuscule, une minuscule et un chiffre.'])
                ],
                'first_options' => ['label' => 'PASSWORD', 'attr' => [ 'class' => 'inscription' ]],
                'second_options' => ['label' => 'PASSWORD_CONFIRMATION', 'attr' => [ 'class' => 'inscription' ]],
            ])
        ;
    }

    public function getBlockPrefix()
    {
        return 'password_update';
    }
}
