<?php

namespace AppBundle\Form\Security;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SubscribeForm extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('siret', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Ex : 43845039481023'
                ],
                'label' => false
            ])
            ->add('identifiant', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Ex : 3957301'
                ],
                'label' => false
            ])
            ->add('nom', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Nom'
                ],
                'label' => false
            ])
            ->add('prenom', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Prénom'
                ],
                'label' => false
            ])
            ->add('email', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Adresse mail'
                ],
                'label' => false
            ])
            ->add('emailCheck', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Confirmation adresse mail'
                ],
                'label' => false
            ])
            ->add('telephone', null, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Téléphone'
                ],
                'label' => false
            ])
            ->add('password', PasswordType::class, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Mot de passe'
                ],
                'label' => false
            ])
            ->add('passwordCheck', PasswordType::class, [
                'attr' => [
                    'class' => 'inscription ptb-8 plr-16',
                    'placeholder' => 'Confirmation mot de passe'
                ],
                'label' => false
            ])
            ->add('thematique', CollectionType::class, [
                'allow_add' => true,
                'prototype' => false,
                'label' => false
            ])
            ->add('cgu', CollectionType::class, [
                'allow_add' => true,
                'prototype' => false,
                'label' => false
            ])
            ->add('cookies', CollectionType::class, [
                'allow_add' => true,
                'prototype' => false,
                'label' => false
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
//        $resolver->setDefaults([
//            'data_class' => 'AppBundle\Entity\Utilisateur'
//        ]);
    }

    public function getBlockPrefix()
    {
        return 'app_bundle_subscribe_form';
    }
}
