<?php

namespace AppBundle\Form\Security;

use AppBundle\Entity\Utilisateur;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\EqualTo;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\Regex;

class PasswordReset extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('new', PasswordType::class, [
                'required' => true,
                'label' => 'NEW_PASSWORD',
                'constraints' => [
                    new Length(['min'=>8]),
                    new Regex(['pattern'=>"/[a-zA-Z0-9]/"])
                ]
            ])
            ->add('confirmation', PasswordType::class, [
                'required' => true,
                'label' => 'PASSWORD_CONFIRMATION',
//                'constraints' => [
//                    new EqualTo([''])
//                ]
            ])
        ;
    }

    public function getBlockPrefix()
    {
        return 'password_update';
    }
}
