<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ModeleDemandeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('typeDecompte', ChoiceType::class, array(
            'choices'  => array(
                'Acompte' => 'Acompte',
                'Solde' => 'Solde',
            ),
            'label' => 'DEMANDE_DECOMPTE'
        ))
            ->add('montant',null, [
                'required' => false,
                'label' => 'DEMANDE_AMOUNT'
            ])
            ->add('taux',null, [
                'required' => false,
                'label' => 'DEMANDE_RATE'
            ])
        ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }

    public function getBlockPrefix()
    {
        return 'app_bundle_modele_demande_type';
    }
}
