<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DemandePaiementType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('etat', FileType::class,[
            'label'=>'DEMANDE_STATUS',
            'required'=>false,

        ])
            ->add('justificatifs', FileType::class,[
                'label'=>'DEMANDE_JUSTIFICATIFS',
                'required'=>false,
            ])
            ->add('lettre', FileType::class,[
                'label'=>'DEMANDE_MAIL',
                'required'=>false,

            ])
            ->add('commentaire', TextareaType::class,[
                'label'=>'DEMANDE_COMMENTARY',
                'required'=>false,
            ])
            ->add('typeDecompte', ChoiceType::class, [
                'choices'  => [
                    'Acompte' => 'Acompte',
                    'Solde' => 'Solde',
                ],
                'label' => 'DEMANDE_DECOMPTE'
            ])
            /*->add('montant',null, [
                'required' => false,
                'label' => 'DEMANDE_AMOUNT'
            ])
            ->add('taux',null, [
                'required' => false,
                'label' => 'DEMANDE_RATE'
            ])*/
            ->add('distinction',null, [
                            'attr' => array('id' => "distinct_form", 'value' => null),
                            'required' => false,
                            'label' => 'distinction'
                        ])

        ;


    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }

    public function getBlockPrefix()
    {
        return 'app_bundle_demande_paiement_type';
    }
}
