<?php

namespace AppBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AddNewAgent extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom',null, [
                'required' => true,
                'label' => 'NAME'
            ])
            ->add('prenom', null, [
                'required' => true,
                'label' => 'FIRSTNAME'
            ])
            ->add('email', null, [
                'required' => true,
                'label' => 'EMAIL'
            ])
            ->add('telephone', null, [
                'required' => false,
                'label' => 'PHONE'
            ])
            ->add('isAdmin', ChoiceType::class, array(
                'choices' => array(
                    'YES' => 1,
                    'NO' => 0
                ),
                'data' => 0,
                'expanded' => true,
                'label' => 'ADMIN',
            ))
            ->add('isActif', ChoiceType::class, array(
                'choices' => array(
                    'YES' => 1,
                    'NO' => 0
                ),
                'data' => 0,
                'expanded' => true,
                'label' => 'ACTIVATE',
            ))
            ->add('password', PasswordType::class, [
                'required' => true,
                'label' => 'PASSWORD',
            ])
            ->add('confirmation', PasswordType::class, [
                'required' => true,
                'label' => 'PASSWORD_CONFIRMATION',
            ])

            ;

    }

    public function configureOptions(OptionsResolver $resolver)
    {

    }

    public function getBlockPrefix()
    {
        return 'app_bundle_add_new_agent';
    }
}
