<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Thematique
 *
 * @ORM\Table(name="thematique", indexes={@ORM\Index(name="fk_thematique_agence1_idx", columns={"agence_code_agence"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\ThematiqueRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Thematique
{
    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=45, nullable=false)
     */
    private $intitule;

    /**
     * @var boolean
     *
     * @ORM\Column(name="visible", type="boolean", nullable=false)
     */
    private $visible;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;


    /**
     * @ORM\Column(name="extension", type="string")
     */
    private $extension;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=5)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $code;

    /**
     * @var \AppBundle\Entity\Agence
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Agence", inversedBy="thematique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="agence_code_agence", referencedColumnName="code_agence")
     * })
     */
    private $agenceCodeAgence;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="AppBundle\Entity\Utilisateur", mappedBy="thematiqueCode")
     */
    private $utilisateur;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->utilisateur = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * @return mixed
     */
    public function getExtension()
    {
        return $this->extension;
    }

    /**
     * @param mixed $extension
     */
    public function setExtension($extension)
    {
        $this->extension = $extension;
    }

    /**
     * @ORM\PrePersist
     */
    public function setCreatedAtValue()
    {
        $this->dateUpdated = new \DateTime();
    }

    /**
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * @param string $intitule
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;
    }

    /**
     * @return bool
     */
    public function isVisible()
    {
        return $this->visible;
    }

    /**
     * @param bool $visible
     */
    public function setVisible($visible)
    {
        $this->visible = $visible;
    }

    /**
     * @return int
     */
    public function getUtilisateurThematiqueId()
    {
        return $this->utilisateurThematiqueId;
    }

    /**
     * @param int $utilisateurThematiqueId
     */
    public function setUtilisateurThematiqueId($utilisateurThematiqueId)
    {
        $this->utilisateurThematiqueId = $utilisateurThematiqueId;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return Agence
     */
    public function getAgenceCodeAgence()
    {
        return $this->agenceCodeAgence;
    }

    /**
     * @param Agence $agenceCodeAgence
     */
    public function setAgenceCodeAgence($agenceCodeAgence)
    {
        $this->agenceCodeAgence = $agenceCodeAgence;
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }

    /**
     * @param \Doctrine\Common\Collections\Collection $utilisateur
     */
    public function setUtilisateur($utilisateur)
    {
        $this->utilisateur = $utilisateur;
    }
    
    public function __toString()
    {
        return $this->code;
    }
        
}

