<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TelechargementDocumentDisposition
 *
 * @ORM\Table(name="telechargement_document_disposition", indexes={@ORM\Index(name="fk_telechargement_document_disposition_interlocuteur1_idx", columns={"interlocuteur_siret"}), @ORM\Index(name="fk_telechargement_document_disposition_document_disposition_idx", columns={"document_disposition_id"}), @ORM\Index(name="fk_telechargement_document_disposition_utilisateur1_idx", columns={"utilisateur_id", "utilisateur_utilisateur_interlocuteur_id", "utilisateur_utilisateur_thematique_id"}), @ORM\Index(name="IDX_29DA2E94FB88E14F", columns={"utilisateur_id"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\TelechargementDocumentDispositionRepository")
 */
class TelechargementDocumentDisposition
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime", nullable=true)
     */
    private $date;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \AppBundle\Entity\DocumentDisposition
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DocumentDisposition", inversedBy="download")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="document_disposition_id", referencedColumnName="id")
     * })
     */
    private $documentDisposition;

    /**
     * @var \AppBundle\Entity\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="utilisateur_id", referencedColumnName="id")
     * })
     */
    private $utilisateur;

    /**
     * TelechargementDocumentDisposition constructor.
     * @param DocumentDisposition $documentDisposition
     * @param Utilisateur $utilisateur
     */
    public function __construct(DocumentDisposition $documentDisposition, Utilisateur $utilisateur)
    {
        $this->date = new \DateTime();
        $this->documentDisposition = $documentDisposition;
        $this->utilisateur = $utilisateur;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return DocumentDisposition
     */
    public function getDocumentDisposition()
    {
        return $this->documentDisposition;
    }

    /**
     * @param DocumentDisposition $documentDisposition
     */
    public function setDocumentDisposition($documentDisposition)
    {
        $this->documentDisposition = $documentDisposition;
    }

    /**
     * @return Utilisateur
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }

    /**
     * @param Utilisateur $utilisateur
     */
    public function setUtilisateur($utilisateur)
    {
        $this->utilisateur = $utilisateur;
    }


}

