<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Ppc
 *
 * @ORM\Table(name="ppc")
 * @ORM\Entity
 */
class Ppc
{
    /**
     * @var string
     *
     * @ORM\Column(name="document_nom", type="string", length=45, nullable=false)
     */
    private $documentNom;

    /**
     * @var string
     *
     * @ORM\Column(name="document_emplacement", type="string", length=255, nullable=false)
     */
    private $documentEmplacement;

    /**
     * @var string
     *
     * @ORM\Column(name="siret", type="string", length=14, nullable=false)
     */
    private $siret;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="code_ppc", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $codePpc;

    /**
     * @return string
     */
    public function getDocumentNom()
    {
        return $this->documentNom;
    }

    /**
     * @param string $documentNom
     */
    public function setDocumentNom($documentNom)
    {
        $this->documentNom = $documentNom;
    }

    /**
     * @return string
     */
    public function getDocumentEmplacement()
    {
        return $this->documentEmplacement;
    }

    /**
     * @param string $documentEmplacement
     */
    public function setDocumentEmplacement($documentEmplacement)
    {
        $this->documentEmplacement = $documentEmplacement;
    }

    /**
     * @return string
     */
    public function getSiret()
    {
        return $this->siret;
    }

    /**
     * @param string $siret
     */
    public function setSiret($siret)
    {
        $this->siret = $siret;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return int
     */
    public function getCodePpc()
    {
        return $this->codePpc;
    }


}

