<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Notification
 *
 * @ORM\Table(name="notification")
 * @ORM\Entity
 */
class Notification
{
    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255, nullable=true)
     */
    private $intitule;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     */
    private $description;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="Date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @var string
     *
     * @ORM\Column(name="interlocuteur_siret", type="string", nullable=true)
     */
    private $interlocuteurSiret;

    /**
     * @var string
     *
     * @ORM\Column(name="agence_code", type="string", length=5, nullable=false)
     */
    private $agenceCode;

    /**
     * @var string
     *
     * @ORM\Column(name="thematique_code", type="string",  nullable=true)
     */
    private $thematiqueCode;


    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * @param string $intitule
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return string
     */
    public function getThematiqueCode()
    {
        return $this->thematiqueCode;
    }

    /**
     * @param string $thematiqueCode
     */
    public function setThematiqueCode($thematiqueCode)
    {
        $this->thematiqueCode = $thematiqueCode;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return string
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @param string $interlocuteurSiret
     */
    public function setInterlocuteurSiret($interlocuteurSiret)
    {
        $this->interlocuteurSiret = $interlocuteurSiret;
    }

    /**
     * @return string
     */
    public function getAgenceCode()
    {
        return $this->agenceCode;
    }

    /**
     * @param string $agenceCode
     */
    public function setAgenceCode($agenceCode)
    {
        $this->agenceCode = $agenceCode;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }




}

