<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ModaliteAide
 *
 * @ORM\Table(name="modalite_aide", indexes={@ORM\Index(name="fk_modalite_aide_dossier_aide1_idx", columns={"dossier_aide_numero"})})
 * @ORM\Entity
 */
class ModaliteAide
{
    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255, nullable=true)
     */
    private $libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_participation", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montantParticipation;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_mandate", type="decimal", precision=2, scale=0, nullable=true)
     */
    private $montantMandate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    /**
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * @param string $libelle
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;
    }

    /**
     * @return string
     */
    public function getMontantParticipation()
    {
        return $this->montantParticipation;
    }

    /**
     * @param string $montantParticipation
     */
    public function setMontantParticipation($montantParticipation)
    {
        $this->montantParticipation = $montantParticipation;
    }

    /**
     * @return string
     */
    public function getMontantMandate()
    {
        return $this->montantMandate;
    }

    /**
     * @param string $montantMandate
     */
    public function setMontantMandate($montantMandate)
    {
        $this->montantMandate = $montantMandate;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }


}

