<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Interlocuteur
 *
 * @ORM\Table(name="interlocuteur", indexes={@ORM\Index(name="fk_interlocuteur_ppc1_idx", columns={"ppc_code_ppc"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\InterlocuteurRepository")
 */
class Interlocuteur
{
    /**
     * @var string
     *
     * @ORM\Column(name="raison_sociale", type="string", length=45, nullable=false)
     */
    private $raisonSociale;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=255, nullable=false)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="identifiant", type="string", length=45, nullable=false)
     */
    private $identifiant;

    /**
     * @var boolean
     *
     * @ORM\Column(name="is_actif", type="boolean", nullable=false)
     */
    private $isActif;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="siret", type="string")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $siret;

    /**
     * @var \AppBundle\Entity\Ppc
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Ppc")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="ppc_code_ppc", referencedColumnName="code_ppc")
     * })
     */
    private $ppcCodePpc;

    /**
     * @var DepotDocument
     *
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\DepotDocument", mappedBy="interlocuteur")
     * @ORM\JoinColumn(name="siret", referencedColumnName="interlocuteur_id")
     */
    private $depoDocuments;

    /**
     * @var \AppBundle\Entity\Agence
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Agence", inversedBy="interlocuteurSiret")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="code_agence", referencedColumnName="code_agence")
     * })
     */
    private $codeAgence;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="AppBundle\Entity\Utilisateur", mappedBy="interlocuteurSiret")
     */
    private $utilisateur;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->utilisateur = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * @return DepotDocument
     */
    public function getDepoDocuments()
    {
        return $this->depoDocuments;
    }

    /**
     * @return Agence
     */
    public function getCodeAgence()
    {
        return $this->codeAgence;
    }

    /**
     * @param Agence $codeAgence
     */
    public function setCodeAgence($codeAgence)
    {
        $this->codeAgence = $codeAgence;
    }

    /**
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->raisonSociale;
    }

    /**
     * @param string $raisonSociale
     */
    public function setRaisonSociale($raisonSociale)
    {
        $this->raisonSociale = $raisonSociale;
    }

    /**
     * @return string
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * @param string $commune
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;
    }

    /**
     * @return string
     */
    public function getIdentifiant()
    {
        return $this->identifiant;
    }

    /**
     * @param string $identifiant
     */
    public function setIdentifiant($identifiant)
    {
        $this->identifiant = $identifiant;
    }

    /**
     * @return bool
     */
    public function isIsActif()
    {
        return $this->isActif;
    }

    /**
     * @param bool $isActif
     */
    public function setIsActif($isActif)
    {
        $this->isActif = $isActif;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return string
     */
    public function getSiret()
    {
        return $this->siret;
    }

    /**
     * @param string $siret
     */
    public function setSiret($siret)
    {
        $this->siret = $siret;
    }

    /**
     * @return Ppc
     */
    public function getPpcCodePpc()
    {
        return $this->ppcCodePpc;
    }

    /**
     * @param Ppc $ppcCodePpc
     */
    public function setPpcCodePpc($ppcCodePpc)
    {
        $this->ppcCodePpc = $ppcCodePpc;
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }

    /**
     * @param \Doctrine\Common\Collections\Collection $utilisateur
     */
    public function setUtilisateur($utilisateur)
    {
        $this->utilisateur = $utilisateur;
    }
    
    public function __toString()
    {
        return $this->raisonSociale;
    }
    
}

