<?php

namespace AppBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Historique
 *
 * @ORM\Table(name="historique", indexes={@ORM\Index(name="fk_historique_utilisateur1_idx", columns={"utilisateur_id", "utilisateur_utilisateur_interlocuteur_id", "utilisateur_utilisateur_thematique_id"}), @ORM\Index(name="IDX_EDBFD5ECFB88E14F", columns={"utilisateur_id"})})
 * @ORM\Entity
 */
class Historique
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime", nullable=true)
     */
    private $date;

    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=45, nullable=true)
     */
    private $type;

    /**
     * @var string
     *
     * @ORM\Column(name="entite", type="string", length=45, nullable=true)
     */
    private $entite;

    /**
     * @var string
     *
     * @ORM\Column(name="message", type="string", length=500, nullable=true)
     */
    private $message;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \AppBundle\Entity\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="utilisateur_id", referencedColumnName="id")
     * })
     */
    private $utilisateur;

    /**
     * Historique constructor.
     * @param string $type
     * @param string $entite
     * @param string $message
     * @param $utilisateur
     */
    public function __construct($type, $entite, $message, $utilisateur)
    {
        $this->date = new DateTime();
        $this->type = $type;
        $this->entite = $entite;
        $this->message = $message;
        $this->utilisateur = $utilisateur;
    }

    /**
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getEntite()
    {
        return $this->entite;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Utilisateur
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }
}

