<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * Entete
 *
 * @ORM\Table(name="entete")
 * @ORM\Entity
 */
class Entete
{


    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=500, nullable=true)
     */
    private $description;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_update", type="datetime", nullable=true)
     */
    private $dateUpdate;

    /**
     * @var integer
     *
     * @ORM\Column(name="utilisateur_update", type="integer", nullable=true)
     */
    private $utilisateurUpdate;

    /**
     * @var string
     *
     * @ORM\Column(name="localisation", type="string", length=45)
     * @ORM\Id
     */
    private $localisation;


    /**
     * @var string
     * @ORM\Column(name="texte", type="string")
     *
     */
    private $texte;

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdate()
    {
        return $this->dateUpdate;
    }

    /**
     * @param \DateTime $dateUpdate
     */
    public function setDateUpdate($dateUpdate)
    {
        $this->dateUpdate = $dateUpdate;
    }

    /**
     * @return int
     */
    public function getUtilisateurUpdate()
    {
        return $this->utilisateurUpdate;
    }

    /**
     * @param int $utilisateurUpdate
     */
    public function setUtilisateurUpdate($utilisateurUpdate)
    {
        $this->utilisateurUpdate = $utilisateurUpdate;
    }

    /**
     * @return string
     */
    public function getTexte()
    {
        return $this->texte;
    }

    /**
     * @param string $texte
     */
    public function setTexte($texte)
    {
        $this->texte = $texte;
    }

    /**
     * @return string
     */
    public function getLocalisation()
    {
        return $this->localisation;
    }

    /**
     * @param string $localisation
     */
    public function setLocalisation($localisation)
    {
        $this->localisation = $localisation;
    }


}

