<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Encaissement
 *
 * @ORM\Table(name="encaissement", indexes={@ORM\Index(name="fk_encaissement_dossier_aide1_idx", columns={"dossier_aide_numero"}), @ORM\Index(name="fk_encaissement_interlocuteur1_idx", columns={"interlocuteur_siret"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\EncaissementsRepository")
 */
class Encaissement
{
    /**
     * @var string
     *
     * @ORM\Column(name="objet", type="string", nullable=true)
     */
    private $objet;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float", nullable=true)
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="nature", type="string", nullable=true)
     */
    private $nature;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_demande_complete", type="datetime", nullable=false)
     */
    private $dateDemandeComplete;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_validation_comptable", type="datetime", nullable=false)
     */
    private $dateValidationComptable;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_paye", type="datetime", nullable=false)
     */
    private $datePaye;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    /**
     * @var \AppBundle\Entity\Interlocuteur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Interlocuteur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="interlocuteur_siret", referencedColumnName="siret")
     * })
     */
    private $interlocuteurSiret;

    /**
     * @return string
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * @param string $objet
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;
    }

    /**
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * @param float $montant
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;
    }

    /**
     * @return string
     */
    public function getNature()
    {
        return $this->nature;
    }

    /**
     * @param string $nature
     */
    public function setNature($nature)
    {
        $this->nature = $nature;
    }

    /**
     * @return \DateTime
     */
    public function getDateDemandeComplete()
    {
        return $this->dateDemandeComplete;
    }

    /**
     * @param \DateTime $dateDemandeComplete
     */
    public function setDateDemandeComplete($dateDemandeComplete)
    {
        $this->dateDemandeComplete = $dateDemandeComplete;
    }


    /**
     * @return \DateTime
     */
    public function getDateValidationComptable()
    {
        return $this->dateValidationComptable;
    }

    /**
     * @param \DateTime $dateValidationComptable
     */
    public function setDateValidationComptable($dateValidationComptable)
    {
        $this->dateValidationComptable = $dateValidationComptable;
    }

    /**
     * @return \DateTime
     */
    public function getDatePaye()
    {
        return $this->datePaye;
    }

    /**
     * @param \DateTime $datePaye
     */
    public function setDatePaye($datePaye)
    {
        $this->datePaye = $datePaye;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return Interlocuteur
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @param Interlocuteur $interlocuteurSiret
     */
    public function setInterlocuteurSiret($interlocuteurSiret)
    {
        $this->interlocuteurSiret = $interlocuteurSiret;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }


}

