<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Echeance
 *
 * @ORM\Table(name="echeance", indexes={@ORM\Index(name="fk_echeance_dossier_aide1_idx", columns={"dossier_aide_numero"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\EcheancesRepository")
 */
class Echeance
{
    /**
     * @var integer
     *
     * @ORM\Column(name="annee", type="integer", nullable=true)
     */
    private $annee;

    /**
     * @var string
     *
     * @ORM\Column(name="montant", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montant;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_echeance", type="datetime", nullable=true)
     */
    private $dateEcheance;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="code_modalite", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $codeModalite;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    /**
     * @return int
     */
    public function getAnnee()
    {
        return $this->annee;
    }

    /**
     * @param int $annee
     */
    public function setAnnee($annee)
    {
        $this->annee = $annee;
    }

    /**
     * @return string
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * @param string $montant
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;
    }

    /**
     * @return \DateTime
     */
    public function getDateEcheance()
    {
        return $this->dateEcheance;
    }

    /**
     * @param \DateTime $dateEcheance
     */
    public function setDateEcheance($dateEcheance)
    {
        $this->dateEcheance = $dateEcheance;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return string
     */
    public function getCodeModalite()
    {
        return $this->codeModalite;
    }


}

