<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DossierAide
 *
 * @ORM\Table(name="dossier_aide", indexes={@ORM\Index(name="fk_dossier_aide_interlocuteur1_idx", columns={"interlocuteur_siret"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\DossierAideRepository")
 */
class DossierAide
{
    /**
     * @var string
     *
     * @ORM\Column(name="ligne_programme", type="string", length=45, nullable=true)
     */
    private $ligneProgramme;

    /**
     * @var string
     *
     * @ORM\Column(name="objet", type="string", nullable=true)
     */
    private $objet;

    /**
     * @var string
     *
     * @ORM\Column(name="localisation", type="string", nullable=true)
     */
    private $localisation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_notification", type="datetime", nullable=true)
     */
    private $dateNotification;

        /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=true)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="etat", type="string", length=45, nullable=true)
     */
    private $etat;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_participation", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montantParticipation;

    /**
     * @var string
     *
     * @ORM\Column(name="suivi_finance_par", type="string", length=255, nullable=true)
     */
    private $suiviFinancePar;

    /**
     * @var string
     *
     * @ORM\Column(name="suivi_technique_par", type="string", length=255, nullable=true)
     */
    private $suiviTechniquePar;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_previsionnel", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montantPrevisionnel;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_mandate", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montantMandate;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_total", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montantTotal;

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $numero;

    /**
     * @var string
     *
     * @ORM\Column(name="justificatifs_paiement", type="string", nullable=true)
     */
    private $justificatifsPaiement;

    /**
     * @var \AppBundle\Entity\Interlocuteur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Interlocuteur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="interlocuteur_siret", referencedColumnName="siret")
     * })
     */
    private $interlocuteurSiret;

    /**
     * @return string
     */
    public function getLigneProgramme()
    {
        return $this->ligneProgramme;
    }

    /**
     * @param string $ligneProgramme
     */
    public function setLigneProgramme($ligneProgramme)
    {
        $this->ligneProgramme = $ligneProgramme;
    }

    /**
     * @return string
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * @param string $objet
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;
    }

    /**
     * @return string
     */
    public function getLocalisation()
    {
        return $this->localisation;
    }

    /**
     * @param string $localisation
     */
    public function setLocalisation($localisation)
    {
        $this->localisation = $localisation;
    }

    /**
     * @return \DateTime
     */
    public function getDateNotification()
    {
        return $this->dateNotification;
    }

    /**
     * @param \DateTime $dateNotification
     */
    public function setDateNotification($dateNotification)
    {
        $this->dateNotification = $dateNotification;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateNotification
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return string
     */
    public function getEtat()
    {
        return $this->etat;
    }

    /**
     * @param string $etat
     */
    public function setEtat($etat)
    {
        $this->etat = $etat;
    }

    /**
     * @return string
     */
    public function getMontantParticipation()
    {
        return $this->montantParticipation;
    }

    /**
     * @param string $montantParticipation
     */
    public function setMontantParticipation($montantParticipation)
    {
        $this->montantParticipation = $montantParticipation;
    }

    /**
     * @return string
     */
    public function getSuiviFinancePar()
    {
        return $this->suiviFinancePar;
    }

    /**
     * @param string $suiviFinancePar
     */
    public function setSuiviFinancePar($suiviFinancePar)
    {
        $this->suiviFinancePar = $suiviFinancePar;
    }

    /**
     * @return string
     */
    public function getSuiviTechniquePar()
    {
        return $this->suiviTechniquePar;
    }

    /**
     * @param string $suiviTechniquePar
     */
    public function setSuiviTechniquePar($suiviTechniquePar)
    {
        $this->suiviTechniquePar = $suiviTechniquePar;
    }

    /**
     * @return string
     */
    public function getMontantPrevisionnel()
    {
        return $this->montantPrevisionnel;
    }

    /**
     * @param string $montantPrevisionnel
     */
    public function setMontantPrevisionnel($montantPrevisionnel)
    {
        $this->montantPrevisionnel = $montantPrevisionnel;
    }

    /**
     * @return string
     */
    public function getMontantMandate()
    {
        return $this->montantMandate;
    }

    /**
     * @param string $montantMandate
     */
    public function setMontantMandate($montantMandate)
    {
        $this->montantMandate = $montantMandate;
    }

    /**
     * @return Interlocuteur
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @param Interlocuteur $interlocuteurSiret
     */
    public function setInterlocuteurSiret($interlocuteurSiret)
    {
        $this->interlocuteurSiret = $interlocuteurSiret;
    }

    /**
     * @return string
     */
    public function getNumero()
    {
        return $this->numero;
    }

    /**
     * @return string
     */
    public function getMontantTotal()
    {
        return $this->montantTotal;
    }

    /**
     * @param string $montantTotal
     */
    public function setMontantTotal($montantTotal)
    {
        $this->montantTotal = $montantTotal;
    }

    /**
     * @return string
     */
    public function getJustificatifsPaiement()
    {
        return $this->justificatifsPaiement;
    }

    /**
     * @param string $justificatifsPaiement
     */
    public function setJustificatifsPaiement($justificatifsPaiement)
    {
        $this->justificatifsPaiement = $justificatifsPaiement;
    }


}

