<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DocumentDossier
 *
 * @ORM\Table(name="document_dossier", indexes={@ORM\Index(name="fk_document_dossier_dossier_aide1_idx", columns={"dossier_aide_numero"})})
 * @ORM\Entity
 */
class DocumentDossier
{
    /**
     * @var string
     *
     * @ORM\Column(name="document_nom", type="string", length=255, nullable=true)
     */
    private $documentNom;

    /**
     * @var string
     *
     * @ORM\Column(name="document_emplacement", type="string", length=255, nullable=true)
     */
    private $documentEmplacement;


    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="string", length=255, nullable=true)
     */
    private $commentaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="string", length=30)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    /**
     * @return string
     */
    public function getDocumentNom()
    {
        return $this->documentNom;
    }

    /**
     * @param string $documentNom
     */
    public function setDocumentNom($documentNom)
    {
        $this->documentNom = $documentNom;
    }

    /**
     * @return string
     */
    public function getDocumentEmplacement()
    {
        return $this->documentEmplacement;
    }

    /**
     * @param string $documentEmplacement
     */
    public function setDocumentEmplacement($documentEmplacement)
    {
        $this->documentEmplacement = $documentEmplacement;
    }


    /**
     * @param \DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * @param string $commentaire
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }


}

