<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DocumentDisposition
 *
 * @ORM\Table(name="document_disposition", indexes={@ORM\Index(name="fk_document_disposition_thematique1_idx", columns={"thematique_code", "thematique_agence_code"}), @ORM\Index(name="fk_document_disposition_interlocuteur1_idx", columns={"interlocuteur_siret"}), @ORM\Index(name="IDX_CEF1880AB5EF358C", columns={"thematique_code"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\DocumentDispositionRepository")
 */
class DocumentDisposition
{
    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="emplacement", type="string", length=255, nullable=true)
     */
    private $emplacement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_depot", type="datetime", nullable=false)
     */
    private $dateDepot;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="string", length=255, nullable=true)
     */
    private $commentaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_fin_publication", type="datetime", nullable=true)
     */
    private $dateFinPublication;

    /**
     * @var string
     *
     * @ORM\Column(name="lien", type="string", length=255, nullable=true)
     */
    private $lien;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="string")
     * @ORM\Id
     */
    private $id;

    /**
     * @var \AppBundle\Entity\Interlocuteur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Interlocuteur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="interlocuteur_siret", referencedColumnName="siret")
     * })
     */
    private $interlocuteurSiret;

    /**
     * @var \AppBundle\Entity\Thematique
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Thematique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="thematique_code", referencedColumnName="code")
     * })
     */
    private $thematiqueCode;

    /**
     * @var TelechargementDocumentDisposition
     *
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\TelechargementDocumentDisposition", mappedBy="documentDisposition")
     * @ORM\JoinColumn(name="id", referencedColumnName="document_disposition_id")
     */
    private $download;

    public function downloaded()
    {
        return count($this->download);
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @return string
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }

    /**
     * @return \DateTime
     */
    public function getDateDepot()
    {
        return $this->dateDepot;
    }

    /**
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * @return \DateTime
     */
    public function getDateFinPublication()
    {
        return $this->dateFinPublication;
    }

    /**
     * @return string
     */
    public function getLien()
    {
        return $this->lien;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return Interlocuteur
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @return Thematique
     */
    public function getThematiqueCode()
    {
        return $this->thematiqueCode;
    }
}

