<?php
/**
 * Created by PhpStorm.
 * User: Arthur Touzard
 * Date: 28/05/2018
 * Time: 09:56
 */

namespace AppBundle\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="document_demande_paiement")
 */
class DocumentDemandePaiement
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */private $id;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    private $nom;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    private $emplacement;

    /**
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\NatureDocument")
     * @ORM\JoinColumn(name="nature_document_id", referencedColumnName="id")
     */
    private $natureDocumentId;

    /**
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @ORM\Column(type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DemandePaiement")
     * @ORM\JoinColumn(name="demande_paiement_id", referencedColumnName="id")
     */
    private $demandePaiementId;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param mixed $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return mixed
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }

    /**
     * @param mixed $emplacement
     */
    public function setEmplacement($emplacement)
    {
        $this->emplacement = $emplacement;
    }

    /**
     * @return mixed
     */
    public function getNatureDocumentId()
    {
        return $this->natureDocumentId;
    }

    /**
     * @param mixed $natureDocumentId
     */
    public function setNatureDocumentId($natureDocumentId)
    {
        $this->natureDocumentId = $natureDocumentId;
    }

    /**
     * @return mixed
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param mixed $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return mixed
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param mixed $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return mixed
     */
    public function getDemandePaiementId()
    {
        return $this->demandePaiementId;
    }

    /**
     * @param mixed $demandePaiementId
     */
    public function setDemandePaiementId($demandePaiementId)
    {
        $this->demandePaiementId = $demandePaiementId;
    }


}