<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DepotDocument
 *
 * @ORM\Table(name="depot_document", indexes={@ORM\Index(name="fk_depot_document_utilisateur1_idx", columns={"utilisateur_id", "utilisateur_utilisateur_interlocuteur_id", "utilisateur_utilisateur_thematique_id"}), @ORM\Index(name="fk_depot_document_thematique1_idx", columns={"thematique_code", "thematique_agence_code"}), @ORM\Index(name="IDX_5F720DE8B5EF358C", columns={"thematique_code"}), @ORM\Index(name="IDX_5F720DE8FB88E14F", columns={"utilisateur_id"})})
 * @ORM\Entity
 */
class DepotDocument
{
    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="emplacement", type="string", length=255, nullable=true)
     */
    private $emplacement;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=true)
     */
    private $description;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_supplementaire", type="string", length=255, nullable=true)
     */
    private $nomSupplementaire;

    /**
     * @var string
     *
     * @ORM\Column(name="emplacement_supplementaire", type="string", length=255, nullable=true)
     */
    private $emplacementSupplementaire;

    /**
     * @var string
     *
     * @ORM\Column(name="description_supplementaire", type="string", length=255, nullable=true)
     */
    private $descriptionSupplementaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_depot", type="datetime", nullable=true)
     */
    private $dateDepot;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="string")
     * @ORM\Id
     */
    private $id;

    /**
     * @var \AppBundle\Entity\Thematique
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Thematique")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="thematique_code", referencedColumnName="code")
     * })
     */
    private $thematiqueCode;

    /**
     * @var \AppBundle\Entity\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="utilisateur_id", referencedColumnName="id")
     * })
     */
    private $utilisateur;

    /**
     * @var \AppBundle\Entity\Interlocuteur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Interlocuteur", inversedBy="depoDocuments")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="interlocuteur_id", referencedColumnName="siret")
     * })
     */
    private $interlocuteur;

    /**
     * DepotDocument constructor.
     * @param string $nom
     * @param string $emplacement
     * @param Thematique $thematiqueCode
     * @param Interlocuteur $interlocuteur
     * @paraphpm Utilisateur $utilisateur
     */
    public function __construct($nom, $emplacement, Thematique $thematiqueCode, Interlocuteur $interlocuteur, Utilisateur $utilisateur)
    {
        $this->setId();
        $this->nom = $nom;
        $this->emplacement = $emplacement;
        $this->thematiqueCode = $thematiqueCode;
        $this->interlocuteur = $interlocuteur;
        $this->utilisateur = $utilisateur;
        $this->dateDepot = new \DateTime();
    }

    /**
     * @return Interlocuteur
     */
    public function getInterlocuteur()
    {
        return $this->interlocuteur;
    }

    /**
     * @param Interlocuteur $interlocuteur
     */
    public function setInterlocuteur($interlocuteur)
    {
        $this->interlocuteur = $interlocuteur;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }

    /**
     * @param string $emplacement
     */
    public function setEmplacement($emplacement)
    {
        $this->emplacement = $emplacement;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getNomSupplementaire()
    {
        return $this->nomSupplementaire;
    }

    /**
     * @param string $nomSupplementaire
     */
    public function setNomSupplementaire($nomSupplementaire)
    {
        $this->nomSupplementaire = $nomSupplementaire;
    }

    /**
     * @return string
     */
    public function getEmplacementSupplementaire()
    {
        return $this->emplacementSupplementaire;
    }

    /**
     * @param string $emplacementSupplementaire
     */
    public function setEmplacementSupplementaire($emplacementSupplementaire)
    {
        $this->emplacementSupplementaire = $emplacementSupplementaire;
    }

    /**
     * @return string
     */
    public function getDescriptionSupplementaire()
    {
        return $this->descriptionSupplementaire;
    }

    /**
     * @param string $descriptionSupplementaire
     */
    public function setDescriptionSupplementaire($descriptionSupplementaire)
    {
        $this->descriptionSupplementaire = $descriptionSupplementaire;
    }

    /**
     * @return \DateTime
     */
    public function getDateDepot()
    {
        return $this->dateDepot;
    }

    /**
     * @param \DateTime $dateDepot
     */
    public function setDateDepot($dateDepot)
    {
        $this->dateDepot = $dateDepot;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    public function setId()
    {
        $this->id = sha1(uniqid());

        return $this;
    }


    /**
     * @return Thematique
     */
    public function getThematiqueCode()
    {
        return $this->thematiqueCode;
    }

    /**
     * @param Thematique $thematiqueCode
     */
    public function setThematiqueCode($thematiqueCode)
    {
        $this->thematiqueCode = $thematiqueCode;
    }

    /**
     * @return Utilisateur
     */
    public function getUtilisateur()
    {
        return $this->utilisateur;
    }

    /**
     * @param Utilisateur $utilisateur
     */
    public function setUtilisateur($utilisateur)
    {
        $this->utilisateur = $utilisateur;
    }


}

