<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DemandePaiementComplementaire
 *
 * @ORM\Table(name="demande_paiement_complementaire", indexes={@ORM\Index(name="fk_demande_paiement_complementaire_demande_paiement1_idx", columns={"demande_paiement_id"})})
 * @ORM\Entity
 */
class DemandePaiementComplementaire
{
    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=255, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="emplacement", type="string", length=255, nullable=true)
     */
    private $emplacement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \AppBundle\Entity\DemandePaiement
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DemandePaiement")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="demande_paiement_id", referencedColumnName="id")
     * })
     */
    private $demandePaiement;

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getEmplacement()
    {
        return $this->emplacement;
    }

    /**
     * @param string $emplacement
     */
    public function setEmplacement($emplacement)
    {
        $this->emplacement = $emplacement;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return DemandePaiement
     */
    public function getDemandePaiement()
    {
        return $this->demandePaiement;
    }

    /**
     * @param DemandePaiement $demandePaiement
     */
    public function setDemandePaiement($demandePaiement)
    {
        $this->demandePaiement = $demandePaiement;
    }


}

