<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DemandePaiement
 *
 * @ORM\Table(name="demande_paiement_dpmo", indexes={@ORM\Index(name="fk_demande_paiement_dossier_aide1_idx", columns={"dossier_aide_numero"})})
 * @ORM\Entity
 */
class DemandePaiement
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date", type="datetime", nullable=true)
     */
    private $date;

    /**
     * @var string
     *
     * @ORM\Column(name="montant", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montant;

    /**
     * @var integer
     *
     * @ORM\Column(name="taux", type="integer", nullable=true)
     */
    private $taux;

    /**
     * @var string
     *
     * @ORM\Column(name="etat", type="string", length=45, nullable=true)
     */
    private $etat;

    /**
     * @var string
     *
     * @ORM\Column(name="type_decompte", type="string", length=45, nullable=true)
     */
    private $typeDecompte;


    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="string", length=255, nullable=true)
     */
    private $commentaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="utilisateur_created", type="integer", nullable=false)
     */
    private $utilisateurCreated;

    /**
     * @var integer
     *
     * @ORM\Column(name="utilisateur_updated", type="integer", nullable=false)
     */
    private $utilisateurUpdated;

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    public function __construct()
    {
        $this->date = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return string
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * @param string $montant
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;
    }

    /**
     * @return int
     */
    public function getTaux()
    {
        return $this->taux;
    }

    /**
     * @param int $taux
     */
    public function setTaux($taux)
    {
        $this->taux = $taux;
    }

    /**
     * @return string
     */
    public function getEtat()
    {
        return $this->etat;
    }

    /**
     * @param string $etat
     */
    public function setEtat($etat)
    {
        $this->etat = $etat;
    }

    /**
     * @return string
     */
    public function getTypeDecompte()
    {
        return $this->typeDecompte;
    }

    /**
     * @param string $typeDecompte
     */
    public function setTypeDecompte($typeDecompte)
    {
        $this->typeDecompte = $typeDecompte;
    }


    /**
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * @param string $commentaire
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return int
     */
    public function getUtilisateurCreated()
    {
        return $this->utilisateurCreated;
    }

    /**
     * @param int $utilisateurCreated
     */
    public function setUtilisateurCreated($utilisateurCreated)
    {
        $this->utilisateurCreated = $utilisateurCreated;
    }

    /**
     * @return int
     */
    public function getUtilisateurUpdated()
    {
        return $this->utilisateurUpdated;
    }

    /**
     * @param int $utilisateurUpdated
     */
    public function setUtilisateurUpdated($utilisateurUpdated)
    {
        $this->utilisateurUpdated = $utilisateurUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }


}