<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Decaissement
 *
 * @ORM\Table(name="decaissement", indexes={@ORM\Index(name="fk_decaissement_interlocuteur1_idx", columns={"interlocuteur_siret"}), @ORM\Index(name="fk_decaissement_dossier_aide1_idx", columns={"dossier_aide_numero"})})
 * @ORM\Entity(repositoryClass="AppBundle\Entity\Repositories\DecaissementsRepository")
 */
class Decaissement
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_demande", type="datetime", nullable=true)
     */
    private $dateDemande;

    /**
     * @var string
     *
     * @ORM\Column(name="montant", type="decimal", precision=20, scale=2, nullable=true)
     */
    private $montant;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_recouvrement_total", type="datetime", nullable=true)
     */
    private $dateRecouvrementTotal;

    /**
     * @var string
     *
     * @ORM\Column(name="objet", type="string", nullable=true)
     */
    private $objet;

    /**
     * @var string
     *
     * @ORM\Column(name="nature", type="string", nullable=true)
     */
    private $nature;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_limite", type="datetime", nullable=true)
     */
    private $dateLimite;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=true)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=true)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $code;

    /**
     * @var \AppBundle\Entity\DossierAide
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\DossierAide")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="dossier_aide_numero", referencedColumnName="numero")
     * })
     */
    private $dossierAideNumero;

    /**
     * @var \AppBundle\Entity\Interlocuteur
     *
     * @ORM\ManyToOne(targetEntity="AppBundle\Entity\Interlocuteur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="interlocuteur_siret", referencedColumnName="siret")
     * })
     */
    private $interlocuteurSiret;

    /**
     * @return \DateTime
     */
    public function getDateDemande()
    {
        return $this->dateDemande;
    }

    /**
     * @param \DateTime $dateDemande
     */
    public function setDateDemande($dateDemande)
    {
        $this->dateDemande = $dateDemande;
    }

    /**
     * @return string
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * @param string $montant
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;
    }

    /**
     * @return \DateTime
     */
    public function getDateRecouvrementTotal()
    {
        return $this->dateRecouvrementTotal;
    }

    /**
     * @param \DateTime $dateRecouvrementTotal
     */
    public function setDateRecouvrementTotal($dateRecouvrementTotal)
    {
        $this->dateRecouvrementTotal = $dateRecouvrementTotal;
    }

    /**
     * @return string
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * @param string $objet
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;
    }

    /**
     * @return string
     */
    public function getNature()
    {
        return $this->nature;
    }

    /**
     * @param string $nature
     */
    public function setNature($nature)
    {
        $this->nature = $nature;
    }

    /**
     * @return \DateTime
     */
    public function getDateLimite()
    {
        return $this->dateLimite;
    }

    /**
     * @param \DateTime $dateLimite
     */
    public function setDateLimite($dateLimite)
    {
        $this->dateLimite = $dateLimite;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return DossierAide
     */
    public function getDossierAideNumero()
    {
        return $this->dossierAideNumero;
    }

    /**
     * @param DossierAide $dossierAideNumero
     */
    public function setDossierAideNumero($dossierAideNumero)
    {
        $this->dossierAideNumero = $dossierAideNumero;
    }

    /**
     * @return Interlocuteur
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @param Interlocuteur $interlocuteurSiret
     */
    public function setInterlocuteurSiret($interlocuteurSiret)
    {
        $this->interlocuteurSiret = $interlocuteurSiret;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }


}

