<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Ban
 *
 * @ORM\Table(name="ban")
 * @ORM\Entity
 */
class Ban
{
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_ban", type="datetime", nullable=false)
     */
    private $dateBan;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_fin_ban", type="datetime", nullable=false)
     */
    private $dateFinBan;

    /**
     * @var string
     *
     * @ORM\Column(name="ip", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $ip;

    /**
     * Ban constructor.
     * @param $ip
     * @param \DateTime $dateFinBan
     */
    public function __construct($ip, \DateTime $dateFinBan)
    {
        $this->ip = $ip;
        $this->dateFinBan = $dateFinBan;
        $this->dateBan = new \DateTime();
    }

    /**
     * @return \DateTime
     */
    public function getDateBan()
    {
        return $this->dateBan;
    }

    /**
     * @param \DateTime $dateBan
     */
    public function setDateBan($dateBan)
    {
        $this->dateBan = $dateBan;
    }

    /**
     * @return \DateTime
     */
    public function getDateFinBan()
    {
        return $this->dateFinBan;
    }

    /**
     * @param \DateTime $dateFinBan
     */
    public function setDateFinBan($dateFinBan)
    {
        $this->dateFinBan = $dateFinBan;
    }

    /**
     * @return string
     */
    public function getIp()
    {
        return $this->ip;
    }

    /**
     * @param string $ip
     */
    public function setIp($ip)
    {
        $this->ip = $ip;
    }


}

