<?php

namespace AppBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Agence
 *
 * @ORM\Table(name="agence")
 * @ORM\Entity
 */
class Agence
{
    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255, nullable=true)
     */
    private $libelle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_updated", type="datetime", nullable=false)
     */
    private $dateUpdated;

    /**
     * @var string
     *
     * @ORM\Column(name="code_agence", type="string", length=45)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $codeAgence;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Interlocuteur", mappedBy="codeAgence")
     */
    private $interlocuteurSiret;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\OneToMany(targetEntity="AppBundle\Entity\Thematique", mappedBy="agenceCodeAgence")
     */
    private $thematique;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->interlocuteurSiret = new ArrayCollection();
        $this->thematique = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * @param string $libelle
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
    }

    /**
     * @return \DateTime
     */
    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }

    /**
     * @param \DateTime $dateUpdated
     */
    public function setDateUpdated($dateUpdated)
    {
        $this->dateUpdated = $dateUpdated;
    }

    /**
     * @return string
     */
    public function getCodeAgence()
    {
        return $this->codeAgence;
    }

    /**
     * @param string $codeAgence
     */
    public function setCodeAgence($codeAgence)
    {
        $this->codeAgence = $codeAgence;
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getInterlocuteurSiret()
    {
        return $this->interlocuteurSiret;
    }

    /**
     * @param \Doctrine\Common\Collections\Collection $interlocuteurSiret
     */
    public function setInterlocuteurSiret($interlocuteurSiret)
    {
        $this->interlocuteurSiret = $interlocuteurSiret;
    }

    /**
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getThematique()
    {
        return $this->thematique;
    }

    /**
     * @param \Doctrine\Common\Collections\Collection $thematique
     */
    public function setThematique($thematique)
    {
        $this->thematique = $thematique;
    }

    public function __toString()
    {
        return $this->libelle;
    }

}

