<?php
/**
 * Created by PhpStorm.
 * User: Arthur Touzard
 * Date: 13/04/2018
 * Time: 17:46
 */

namespace AppBundle\Controller;


use AppBundle\Entity\Interlocuteur;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\XmlEncoder;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;

class InterlocuteurController extends Controller
{
    private $serializer;

    /**
     * InterlocuteurController constructor.
     */
    public function __construct()
    {
        $encoders = array(new XmlEncoder(), new JsonEncoder());
        $normalizers = array(new ObjectNormalizer());

        $this->serializer = new Serializer($normalizers, $encoders);
    }


    /**
     * @Route("/api/interlocThem/{siret}", name="ajax_interloc_thematique", options={"expose"=true})
     */
    public function getInterlocuteurThematiques($siret)
    {
        $doc = $this->getDoctrine();
        $interloc = $doc->getRepository(Interlocuteur::class)->find($siret);

        $return = $this->getDoctrine()->getRepository("AppBundle:Thematique")->getThematiques($interloc->getCodeAgence()->getCodeAgence());

        return new JsonResponse($return);
    }
}